/* toc.js
 * Copyright © 2016, 2017 Mark Damon Hughes
 * See BSDLicense.txt
 *
 * Collects all h2-h5 tags in the document and builds a hierarchical table of contents with links, in 2 columns.
 * 
 * Usage:
 * 
 * <head>
 * <script src='toc.js' type='text/javascript' language='javascript'></script>
 * </head>
 * <body>
 * <div id='toc'>
 * [NOTE: You must have Javascript enabled]
 * </div>
 * 
 * … to end of file …
 * <script type='text/javascript' language='javascript'>tocInit();</script>
 * </body>
 */

function tocNode(nodes, rows) {
	for (var i = 0; i < nodes.length; ++i) {
		var node = nodes[i];
		if (node.nodeType != 1) {
			continue;
		}
		var tn = node.tagName;
		if (tn == "H2" || tn == "H3" || tn == "H4" || tn == "H5") {
			var id = node.getAttribute("id");
			if (id) {
				var depth = parseInt(tn.substring(1, 2), 10);
				var value = node.innerHTML;
				var line = "";
				for (var t = 0; t < depth - 1; ++t) {
					line += "  ";
				}
				line += "<a href='#"+id+"' class='toclink'>"+value+"<\/a>\n";
				rows.push(line);
			}
		}
		tocNode(node.childNodes, rows);
	}
}

function tocText(rows) {
	var text = "<table width='100%'><tr><td width='50%'><pre>";
	for (var i = 0, half = Math.ceil(rows.length/2); i < rows.length; ++i) {
		if (i == half) {
			text += "</pre></td><td width='50%'><pre>";
		}
		text += rows[i];
	}
	text += "</pre></td></tr></table>";
	return text;
}

function tocInit() {
	var rows = [];
	tocNode(document.body.childNodes, rows);
	document.getElementById("toc").innerHTML = tocText(rows);
}
